/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.core.registry;

import com.minecraftabnormals.abnormals_core.core.util.BiomeUtil;
import com.minecraftabnormals.abnormals_core.core.util.registry.BiomeSubRegistryHelper;
import com.minecraftabnormals.environmental.core.Environmental;
import com.minecraftabnormals.environmental.core.EnvironmentalConfig;
import com.mojang.datafixers.util.Pair;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="environmental", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnvironmentalBiomes {
    private static final BiomeSubRegistryHelper HELPER = (BiomeSubRegistryHelper)Environmental.REGISTRY_HELPER.getBiomeSubHelper();
    public static final BiomeSubRegistryHelper.KeyedBiome MARSH = HELPER.createBiome("marsh", EnvironmentalBiomes::createMarshBiome);
    public static final BiomeSubRegistryHelper.KeyedBiome MUSHROOM_MARSH = HELPER.createBiome("mushroom_marsh", EnvironmentalBiomes::createMarshBiome);
    public static final BiomeSubRegistryHelper.KeyedBiome BLOSSOM_WOODS = HELPER.createBiome("blossom_woods", () -> EnvironmentalBiomes.createBlossomBiome(0.1f, 0.2f));
    public static final BiomeSubRegistryHelper.KeyedBiome BLOSSOM_HILLS = HELPER.createBiome("blossom_hills", () -> EnvironmentalBiomes.createBlossomBiome(0.45f, 0.3f));
    public static final BiomeSubRegistryHelper.KeyedBiome BLOSSOM_HIGHLANDS = HELPER.createBiome("blossom_highlands", () -> EnvironmentalBiomes.createBlossomBiome(2.0f, 0.15f));
    public static final BiomeSubRegistryHelper.KeyedBiome BLOSSOM_VALLEYS = HELPER.createBiome("blossom_valleys", () -> EnvironmentalBiomes.createBlossomBiome(0.1f, 0.01f));

    public static void addBiomesToGeneration() {
        BiomeUtil.addHillBiome((RegistryKey)MARSH.getKey(), (Pair[])new Pair[]{Pair.of((Object)MARSH.getKey(), (Object)3), Pair.of((Object)MUSHROOM_MARSH.getKey(), (Object)1)});
        BiomeUtil.addHillBiome((RegistryKey)BLOSSOM_WOODS.getKey(), (Pair[])new Pair[]{Pair.of((Object)BLOSSOM_HILLS.getKey(), (Object)1)});
        BiomeUtil.addHillBiome((RegistryKey)BLOSSOM_HIGHLANDS.getKey(), (Pair[])new Pair[]{Pair.of((Object)BLOSSOM_VALLEYS.getKey(), (Object)1)});
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(MARSH.getKey(), ((Integer)EnvironmentalConfig.COMMON.marshWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(MUSHROOM_MARSH.getKey(), ((Integer)EnvironmentalConfig.COMMON.mushroomMarshWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(BLOSSOM_WOODS.getKey(), ((Integer)EnvironmentalConfig.COMMON.blossomWoodsWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(BLOSSOM_HILLS.getKey(), ((Integer)EnvironmentalConfig.COMMON.blossomHillsWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(BLOSSOM_HIGHLANDS.getKey(), ((Integer)EnvironmentalConfig.COMMON.blossomHighlandsWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(BLOSSOM_VALLEYS.getKey(), ((Integer)EnvironmentalConfig.COMMON.blossomValleysWeight.get()).intValue()));
    }

    public static void addBiomeTypes() {
        BiomeDictionary.addTypes((RegistryKey)MARSH.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP});
        BiomeDictionary.addTypes((RegistryKey)MUSHROOM_MARSH.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.RARE, BiomeDictionary.Type.WET, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SWAMP});
        BiomeDictionary.addTypes((RegistryKey)BLOSSOM_WOODS.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RARE});
        BiomeDictionary.addTypes((RegistryKey)BLOSSOM_HILLS.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RARE, BiomeDictionary.Type.HILLS});
        BiomeDictionary.addTypes((RegistryKey)BLOSSOM_HIGHLANDS.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RARE, BiomeDictionary.Type.MOUNTAIN});
        BiomeDictionary.addTypes((RegistryKey)BLOSSOM_VALLEYS.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RARE, BiomeDictionary.Type.PLAINS});
        BiomeDictionary.addTypes((RegistryKey)Biomes.field_203620_Z, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SNOWY});
    }

    private static Biome createMarshBiome() {
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.SWAMP).func_205421_a(-0.25f).func_205420_b(0.0f).func_205414_c(0.8f).func_205417_d(0.9f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(6134398).func_235248_c_(2302743).func_235239_a_(12638463).func_242539_d(EnvironmentalBiomes.getSkyColorWithTemperatureModifier(0.75f)).func_242541_f(6263617).func_242540_e(6975545).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(new MobSpawnInfo.Builder().func_242577_b()).func_242457_a(new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j).func_242508_a()).func_242455_a();
    }

    private static Biome createBlossomBiome(float depth, float scale) {
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(depth).func_205420_b(scale).func_205414_c(0.75f).func_205417_d(0.8f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(5216182).func_235248_c_(335411).func_235239_a_(12638463).func_242539_d(EnvironmentalBiomes.getSkyColorWithTemperatureModifier(0.75f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(new MobSpawnInfo.Builder().func_242577_b()).func_242457_a(new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j).func_242508_a()).func_242455_a();
    }

    private static int getSkyColorWithTemperatureModifier(float temperature) {
        float lvt_1_1_ = temperature / 3.0f;
        lvt_1_1_ = MathHelper.func_76131_a((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
    }
}

